package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


import app.firezone.synk.network.Activities.TransactionDetailActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemHistoryBinding;
import app.firezone.synk.network.model.TransactionModel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class TrHistoryAdapter extends RecyclerView.Adapter<TrHistoryAdapter.videHolder> {

    Context context;
    ArrayList<TransactionModel>list;

    public TrHistoryAdapter(Context context, ArrayList<TransactionModel> list) {
        this.context = context;
        this.list = list;
    }

    @NonNull
    @Override
    public videHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        View view = LayoutInflater.from(context).inflate(R.layout.item_history,parent,false);
        return new videHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull videHolder holder, int position) {
        final TransactionModel model = list.get(position);

        holder.binding.amountTxt.setText(" ₹" + model.getAmount());
        holder.binding.method.setText("VIA: " + model.getMethod());
        holder.binding.date.setText(formatDateTime(model.getDate(), model.getTime()));
        holder.binding.transactionId.setText(model.getTransactionId());
        holder.binding.type.setText(model.getType());


        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(context, TransactionDetailActivity.class);
                intent.putExtra("amount", model.getAmount());
                intent.putExtra("type", model.getType());
                intent.putExtra("method", model.getMethod());
                intent.putExtra("date", model.getDate());
                intent.putExtra("time", model.getTime());
                intent.putExtra("transactionId", model.getTransactionId());
                intent.putExtra("status", model.getStatus());
                context.startActivity(intent);

            }
        });

    }

    private String formatDateTime(String dateStr, String timeStr) {
        try {
            // Combine date and time into a single string
            String input = dateStr + " " + timeStr;

            // Input format (e.g., "20-06-2025 12:17:23")
            SimpleDateFormat inputFormat = new SimpleDateFormat("dd-MM-yy HH:mm:ss", Locale.getDefault());

            // Output format (e.g., "10 Jun 2025, 21:02")
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd MMM yy, HH:mm", Locale.getDefault());

            Date date = inputFormat.parse(input);
            return outputFormat.format(date);

        } catch (ParseException e) {
            e.printStackTrace();
            return dateStr + ", " + timeStr; // fallback
        }
    }


    @Override
    public int getItemCount() {
        return list.size();
    }

    public  class videHolder extends RecyclerView.ViewHolder {

        ItemHistoryBinding binding;
        public videHolder(@NonNull View itemView) {
            super(itemView);

            binding = ItemHistoryBinding.bind(itemView);
        }
    }

}

